//[BotStacks Chat SDK](../../index.md)/[ai.botstacks.sdk.ui.components](index.md)/[Badge](-badge.md)

# Badge

[common]\

@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)

fun [Badge](-badge.md)(count: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier)

Badge

A &quot;badge&quot; to show a count.

This is utilized in the [MessageList](-message-list.md) component serving as the date separators, in the [ChatList](-chat-list.md) component to show unread counts, and in the ChannelSettingsView for displaying admins.

#### Parameters

common

| | |
|---|---|
| count | Count to display in the badge. |
| modifier | the Modifier to be applied to this Badge |

[common]\

@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)

fun [Badge](-badge.md)(label: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier)

Badge

A &quot;badge&quot; to show a label.

This is utilized in the [MessageList](-message-list.md) component serving as the date separators, in the [ChatList](-chat-list.md) component to show unread counts, and in the ChannelSettingsView for displaying admins.

#### Parameters

common

| | |
|---|---|
| label | The text to be displayed in the badge. |
| modifier | the Modifier to be applied to this Badge |

[common]\

@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)

fun [Badge](-badge.md)(label: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, backgroundColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacks.colorScheme.primary, contentColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacks.colorScheme.onPrimary, contentPadding: [PaddingValues](https://developer.android.com/reference/kotlin/androidx/compose/foundation/layout/PaddingValues.html) = PaddingValues(
        horizontal = BotStacks.dimens.grid.x2,
        vertical = BotStacks.dimens.grid.x1
    ), fontStyle: [FontStyle](../ai.botstacks.sdk.ui.theme/-font-style/index.md) = BotStacks.fonts.caption2, shape: [Shape](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Shape.html) = CircleShape)

Badge

A &quot;badge&quot; to show a label.

This is utilized in the [MessageList](-message-list.md) component serving as the date separators, in the [ChatList](-chat-list.md) component to show unread counts, and in the ChannelSettingsView for displaying admins.

#### Parameters

common

| | |
|---|---|
| label | The text to be displayed in the badge. |
| modifier | the Modifier to be applied to this Badge |
| backgroundColor | Background color of the badge. |
| contentColor | Text color of the badge. |
| contentPadding | Padding around the badge content. |
| fontStyle | Style for the text in the badge. |
| shape | Shape of the badge. |
